@extends('layouts.app')

@section('content')
<div class="container">
    <h1>User Details</h1>

    <div class="card">
        <div class="card-body">
            <h5 class="card-title">{{ $user->name }}</h5>
            <p class="card-text"><strong>Email:</strong> {{ $user->email }}</p>
            <p class="card-text"><strong>Role:</strong> {{ $user->role }}</p>
            <p class="card-text"><strong>Created At:</strong> {{ $user->created_at }}</p>
            <p class="card-text"><strong>Updated At:</strong> {{ $user->updated_at }}</p>

            @if ($user->profile)
                <h5 class="mt-4">Profile Details</h5>
                <p class="card-text"><strong>Business Name:</strong> {{ $user->profile->business_name }}</p>
                <p class="card-text"><strong>Address:</strong> {{ $user->profile->business_address_line1 }}, {{ $user->profile->business_address_line2 }}</p>
                <p class="card-text"><strong>City:</strong> {{ $user->profile->city }}</p>
                <p class="card-text"><strong>State:</strong> {{ $user->profile->state }}</p>
                <p class="card-text"><strong>Zip Code:</strong> {{ $user->profile->zip_code }}</p>
                <p class="card-text"><strong>Country:</strong> {{ $user->profile->country }}</p>
                <p class="card-text"><strong>Phone Number:</strong> {{ $user->profile->phone_number }}</p>
                <p class="card-text"><strong>Incorporation Details:</strong> {{ $user->profile->incorporation_details }}</p>
            @else
                <p class="text-muted">No profile details available.</p>
            @endif

            <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">Back to Users</a>
        </div>
    </div>
</div>
@endsection